package com.ptteng.yi.etl.util;

import com.ptteng.yi.nucleus.model.AppointOrder;
import com.qding.common.util.DataUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by cjsff 2018年1月17日13:03:05
 */
public class DynamicUtil {

    private static final Log log = LogFactory.getLog(DynamicUtil.class);

    /**
     * @Description :订单推送列表
     * @param
     * @param
     * @return
     */
    public static Map<String, Object> getOrdersList(Long current, Long now) {

        Map<String, Object> params = new HashMap<String, Object>();

        if (DataUtils.isNullOrEmpty(current) || DataUtils.isNullOrEmpty(now)) {
            log.info("未传参");
            return params;
        }

        params.put("time & <=", current);

        params.put("time_end  & <=  ", now);

        params.put("type  & in  ", "(" + 1 + "," + 2 + "," + 3 + "," + 4 + ")");

        params.put("@order", "create_at");
        params.put("@query", "id");

        params.put("@table", "appoint_order");

        return params;
    }

    /**
     * @Description :订单推送列表
     * @param
     * @param
     * @return
     */
    public static Map<String, Object> getOrderListByCoach(Long cid) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("coach", cid);
        params.put("type", AppointOrder.ORDER_COMPLETED_EVALUATED_YES);
        params.put("@query", "id");
        params.put("@table", "appoint_order");
        return params;
    }

}
